/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington

//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "g_local.h"

void Use_Target_Music (edict_t *ent, edict_t *other, edict_t *activator)
{

	ent->s.sound = ent->noise_index;	// start it
			
	gi.positioned_sound (ent->s.origin, ent, CHAN_VOICE, ent->noise_index, 1, 1, 0);


}

void SP_target_music (edict_t *ent)
{

	if (CustSong == 6)       snd_fry6 = gi.soundindex("ambient/a1.wav"); //some weird ballad
	else if (CustSong == 7)  snd_fry7 = gi.soundindex("ambient/a2.wav"); //Awake - godsmack
	else if (CustSong == 8)  snd_fry8 = gi.soundindex("ambient/a3.wav"); //glisterine - Homebrew
	else if (CustSong == 9)  snd_fry9 = gi.soundindex("ambient/a4.wav");  //cop killer - 
	else if (CustSong == 10) snd_fry10 = gi.soundindex("ambient/a5.wav"); //demons - NIN
	else if (CustSong == 11) snd_fry11 = gi.soundindex("ambient/a6.wav"); //kill me - NIN
	else if (CustSong == 12) snd_fry12 = gi.soundindex("ambient/a7.wav"); //you leave me cold - danzig
	else if (CustSong == 13) snd_fry13 = gi.soundindex("ambient/a8.wav"); //if there is a hell - NIN
	else if (CustSong == 14) snd_fry14 = gi.soundindex("ambient/a9.wav"); //you could have it all - NIN
	else if (CustSong == 15) snd_fry15 = gi.soundindex("ambient/b1.wav"); //Here she comes - danzig
	else if (CustSong == 16) snd_fry16 = gi.soundindex("ambient/b2.wav"); //respect - pantara
	else if (CustSong == 17) snd_fry17 = gi.soundindex("ambient/b3.wav"); //physical NIN
	else if (CustSong == 18) snd_fry18 = gi.soundindex("ambient/b4.wav"); //the crow theme song
	else if (CustSong == 19) snd_fry19 = gi.soundindex("ambient/b5.wav"); //david bowie and NIN - reptile
	else if (CustSong == 20) snd_fry20 = gi.soundindex("ambient/b6.wav"); //wacked NIN
	else if (CustSong == 21) snd_fry21 = gi.soundindex("ambient/b7.wav"); //didnt you NIN
	else if (CustSong == 22) snd_fry22 = gi.soundindex("ambient/b8.wav"); //Satans child - danzig
	else if (CustSong == 23) snd_fry23 = gi.soundindex("ambient/b9.wav"); //I am NIN
	else if (CustSong == 24) snd_fry24 = gi.soundindex("ambient/c1.wav"); //I wear my sunglasses at night
	else if (CustSong == 25) snd_fry25 = gi.soundindex("ambient/c2.wav"); //everything is blue in this world NIN
	else if (CustSong == 26) snd_fry26 = gi.soundindex("ambient/c3.wav"); // down in the belly of the beast i lie - danzig
	else if (CustSong == 27) snd_fry27 = gi.soundindex("ambient/c4.wav"); //soul of misery - danzig
	else if (CustSong == 28) snd_fry28 = gi.soundindex("ambient/c5.wav"); // kryptonite
	else if (CustSong == 29) snd_fry29 = gi.soundindex("ambient/c6.wav"); // were in this together now NIN
	else if (CustSong == 30) snd_fry30 = gi.soundindex("ambient/c7.wav"); //how does it feel NIN
	else if (CustSong == 31) snd_fry31 = gi.soundindex("gtpitbullet/ozzy_crazytrain.wav"); // crazy train - ozzy
	else if (CustSong == 32) snd_fry32 = gi.soundindex("gtpitbullet/megadeth_sod.wav"); // sod - megadeth
	else if (CustSong == 33) snd_fry33 = gi.soundindex("gtpitbullet/sandman.wav"); //
	
	ent->classname="target_music";

	if (CustSong == 0) ent->s.sound = 0;
	else if (CustSong == 1)     ent->s.sound = snd_fry1;
	else if (CustSong == 2)     ent->s.sound = snd_fry2;
	else if (CustSong == 3)     ent->s.sound = snd_fry3;
	else if (CustSong == 4)     ent->s.sound = snd_fry4;
	else if (CustSong == 5)     ent->s.sound = snd_fry5;
	else if (CustSong == 6)     ent->s.sound = snd_fry6;
	else if (CustSong == 7)     ent->s.sound = snd_fry7;
	else if (CustSong == 8)     ent->s.sound = snd_fry8;
	else if (CustSong == 9)     ent->s.sound = snd_fry9;
	else if (CustSong == 10)	ent->s.sound = snd_fry10;
	else if (CustSong == 11)	ent->s.sound = snd_fry11;
	else if (CustSong == 12)	ent->s.sound = snd_fry12;
	else if (CustSong == 13)	ent->s.sound = snd_fry13;
	else if (CustSong == 14)	ent->s.sound = snd_fry14;
	else if (CustSong == 15)	ent->s.sound = snd_fry15;
	else if (CustSong == 16)	ent->s.sound = snd_fry16;
	else if (CustSong == 17)	ent->s.sound = snd_fry17;
	else if (CustSong == 18)	ent->s.sound = snd_fry18;
	else if (CustSong == 19)	ent->s.sound = snd_fry19;
	else if (CustSong == 20)	ent->s.sound = snd_fry20;
	else if (CustSong == 21)	ent->s.sound = snd_fry21;
	else if (CustSong == 22)	ent->s.sound = snd_fry22;
	else if (CustSong == 23)	ent->s.sound = snd_fry23;
	else if (CustSong == 24)	ent->s.sound = snd_fry24;
	else if (CustSong == 25)	ent->s.sound = snd_fry25;
	else if (CustSong == 26)	ent->s.sound = snd_fry26;
	else if (CustSong == 27)	ent->s.sound = snd_fry27;
	else if (CustSong == 28)	ent->s.sound = snd_fry28;
	else if (CustSong == 29)	ent->s.sound = snd_fry29;
	else if (CustSong == 30)	ent->s.sound = snd_fry30;
	else if (CustSong == 31)	ent->s.sound = snd_fry31;
	else if (CustSong == 32)	ent->s.sound = snd_fry32;
	else if (CustSong == 33)	ent->s.sound = snd_fry33;

	ent->use = Use_Target_Music;
	// must link the entity so we get areas and clusters so
	// the server can determine who to send updates to
	gi.linkentity (ent);

    level.num_speakers++;

//	gi.dprintf("[Speaker %i]\n",level.num_speakers);


}


void removespeakers(edict_t *ent)
{
  
   edict_t *nix;

   nix = NULL;

   while ((nix = G_Find (nix, FOFS(classname), "target_music")) != NULL)
   {
 	nix->think = G_FreeEdict;
	nix->nextthink = level.time + 1.0;
    level.num_speakers--;
   }

   speakersloaded = false;
}

// addition to get the data from the file without needing trimstring which was used in the original.
qboolean savespeakerdata(edict_t *ent)
{
    FILE        *fp;
    int         i;
    char        filename[MAX_QPATH];
    cvar_t      *game_dir,*mapname;
    newitem_t   *other_newitem_head;

    game_dir = gi.cvar ("game", "", 0);
    mapname = gi.cvar ("mapname", "", 0);

#ifdef  _WIN32
    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\speakerconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change .ent to the file extension you want
#else
    strcpy(filename, "./");
    strcat(filename, game_dir->string);
    strcat(filename, "/speakerconfig/");
    strcat(filename, level.mapname);
    strcat(filename, ".ent"); // change .ent to the file extension you want
#endif

    if (!newitem_head)
    {
        if (fp = fopen (filename, "rt")) // checks to see if the file exists
        {
	    fclose(fp);
            safe_cprintf(ent,PRINT_HIGH,"ERASING NEW ITEMS DATA... ");
            if (remove(filename)==0)
                return 1;
        }
        
        return 0;
    }

    fp = fopen (filename, "wt");
    if (!fp)
        return 0;
    
    fprintf(fp,"# ADDED SPEAKERS DATA FILE\n");
    fprintf(fp,"# Warning: Modifying this file may cause errors in the game\n");
    fprintf(fp,"\n");
    fprintf(fp,"[ItemData]\n");
    
    // Surf the linked list :)
    other_newitem_head=newitem_head;

    while (other_newitem_head)
    {
        fprintf(fp,"%d %d %d %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
        other_newitem_head=other_newitem_head->next;
    }

    fclose(fp);
    
    return 1;

}






int GetLineFromSpeakerFile(FILE *in, char s[])
{
	int i, c;

	// This reads characters from in into s until MAX_LINE_SIZE-1 is reached,
	// a newline character is reached, or an EOF is reached.
	for (i = 0; i < 254 && (c = fgetc(in)) != '\n' && c != EOF; i++)
		s[i] = c;
	// Add a '\0' to the end of s
	s[i] = '\0';
	return i;
}
// end addition


qboolean load_speaker_data(void)
{
    FILE        *fp;
    char        filename[MAX_QPATH],classname[64],buffer[256];
    cvar_t      *game_dir;
    vec3_t      spot;
    long        line;
    int         i,a,b,c;
    qboolean    inkey=0;
    
    game_dir = gi.cvar ("game", "", 0);

    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\speakerconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change file extension here


    fp = fopen (filename, "rt");
    
	if (!fp)
	{
		gi.dprintf("-------------------------------------\n");
	    gi.dprintf ("Speaker File -> %s.ent Not Found!\n",level.mapname);
        return 0;
	}
    
    line=0;

    speakersloaded = true;
	
	while (!feof(fp))
    {
        line++;
	    GetLineFromSpeakerFile(fp,buffer);        // modification in this codeblock to not use trimstring
        
		if (buffer[0]=='\0' || buffer[0]=='#')
            continue;
        if (!inkey)
        {
            // Search for [ItemData] key
            if (Q_stricmp(buffer,"[ItemData]")!=0)
                continue;
            inkey=1;
        }
        else
        {
            classname[0]='\0';
            sscanf(buffer,"%d %d %d %63s",&a,&b,&c,classname);
            spot[0]=(float)a;
            spot[1]=(float)b;
            spot[2]=(float)c;
                    
            if (strlen(classname)==0 || !FindItemByClassname(classname))
            {
                
				    edict_t *ent;
				
					ent = G_Spawn();

					ent->is_real = false;

            		ent->classname=classname;

					VectorCopy (spot, ent->s.origin);
                    ent->s.origin[2] += 16;
					
                   	gi.linkentity (ent);
   
                  	ED_CallSpawn(ent);

                    if (CustMessage == 1)
					gi.dprintf("[Speaker Creator Added -> %s] at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
            }

            else 
				
				
				if (deathmatch->value || coop->value)
            {
					
				    spawnitembyclassname(spot,classname,1);
				    //gi.dprintf("Added %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
			}
		
				
             else
			 {


                spawnitembyclassname(spot,classname,0);
                //gi.dprintf("Loaded %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
				
			}
        
		}
    }

    fclose(fp);
    
    return 1;
}



void Cmd_Savespeakers_f(edict_t *ent)
{
    safe_cprintf(ent, PRINT_HIGH, "Saving new speaker data for this level... ");
    if (savespeakerdata(ent))
        safe_cprintf(ent, PRINT_HIGH, "OK\n");
    else
        safe_cprintf(ent, PRINT_HIGH, "ERROR! No new speakers?\n");
}


